package players

import "time"

type Player struct {
	Name           string
	DOB            time.Time
	PositionalData PositionalData

	Goalkeeping  Stat
	Tackling     Stat
	ClosingDown  Stat
	Clearances   Stat
	LongBalls    Stat
	Crossing     Stat
	Heading      Stat
	ShortPassing Stat
	Finishing    Stat
}

func (p Player) Goalkeeper() float64 {
	return (p.Goalkeeping.Current + (p.Clearances.Current / 2)) * p.PositionalData.Gk
}

func (p Player) Defence(ps PositionalSide) float64 {
	return (p.Tackling.Current + p.ClosingDown.Current + p.Clearances.Current + (p.LongBalls.Current / 2)) * p.PositionalData.Defence * p.PositionalData.FootednesMultiplier(ps)
}

func (p Player) Central(ps PositionalSide) float64 {
	return ((p.Tackling.Current / 2) + (p.ClosingDown.Current / 2) + p.Clearances.Current + p.LongBalls.Current + p.ShortPassing.Current) * p.PositionalData.Midfield * p.PositionalData.FootednesMultiplier(ps)
}

func (p Player) Winger(ps PositionalSide) float64 {
	return (p.LongBalls.Current + p.ShortPassing.Current + (p.Crossing.Current * 2) + p.Finishing.Current) * p.PositionalData.Midfield * p.PositionalData.FootednesMultiplier(ps)
}

func (p Player) Forward(ps PositionalSide) float64 {
	return (p.Heading.Current + p.ShortPassing.Current + p.Finishing.Current) * p.PositionalData.Striker * p.PositionalData.FootednesMultiplier(ps)
}
